/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.snmp;

import com.ibm.hwmca.base.settings.snmp.SnmpConstants;
import com.ibm.hwmca.base.settings.snmp.SnmpErrorIds;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;

public class SnmpComNameBean
extends PanelBean
implements SnmpConstants,
SnmpErrorIds {
    private static final String TRACE_MASKT = "XSNMPCBT";
    private static final String TRACE_MASKF = "XSNMPCBF";
    private static final String TRACE_MASKD = "XSNMPCBD";
    private static final String SNMP_MESSAGES_FILENAME = "com.ibm.hwmca.base.res.message";
    private static final String SNMP_MESSAGE_BOX_TITLE_KEY = "SNMP.TITLE";
    private static final String SNMP_NAME_MISSING_TEXT_KEY = "SNMP004.TEXT";
    private static final String SNMP_ADDRESS_MISSING_TEXT_KEY = "SNMP005.TEXT";
    private static final String SNMP_ADDRESS_INVALID_TEXT_KEY = "SNMP006.TEXT";
    private static final String SNMP_NETWORK_MASK_MISSING_TEXT_KEY = "SNMP007.TEXT";
    private static final String SNMP_NETWORK_MASK_INVALID_TEXT_KEY = "SNMP008.TEXT";
    private String m_sNameEdit = "";
    private String m_sAddressEdit = "";
    private String m_sNetworkMaskEdit = "";
    private String[] m_sAccessTypeSelection = new String[0];
    private String accessType = "";
    private String[] accessButtons = new String[]{"ReadOnlyItem", "ReadWriteItem"};
    private String[] accessTypes = new String[]{"read", "write"};

    public String getNameEdit() {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.getNameEdit()");
        return this.m_sNameEdit;
    }

    public void setNameEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.setNameEdit(" + s + ")");
        this.m_sNameEdit = s;
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.setNameEdit()");
    }

    public String getAddressEdit() {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.getAddressEdit()");
        return this.m_sAddressEdit;
    }

    public void setAddressEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.setAddressEdit(" + s + ")");
        this.m_sAddressEdit = s;
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.setAddressEdit()");
    }

    public String getNetworkMaskEdit() {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.getNetworkMaskEdit()");
        return this.m_sNetworkMaskEdit;
    }

    public void setNetworkMaskEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.setNetworkMaskEdit(" + s + ")");
        this.m_sNetworkMaskEdit = s;
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.setNetworkMaskEdit()");
    }

    public void setAccessType(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.setAccessType(" + s + ")");
        this.accessType = s;
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.setAccessType()");
    }

    public String[] getAccessTypeSelection() {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.getAccessTypeSelection()");
        return this.m_sAccessTypeSelection;
    }

    public void setAccessTypeSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.setAccessTypeSelection(" + selected + ")");
        this.m_sAccessTypeSelection = selected;
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.setAccessTypeSelection()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> SnmpComNameBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.load()");
        if (this.accessType.equals("read")) {
            this.setAccessTypeSelection(new String[]{this.getMountPrefix() + "ReadOnlyItem"});
        } else if (this.accessType.equals("write")) {
            this.setAccessTypeSelection(new String[]{this.getMountPrefix() + "ReadWriteItem"});
        } else {
            this.setAccessTypeSelection(new String[]{this.getMountPrefix() + "ReadOnlyItem"});
        }
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.load()");
    }

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> SnmpComNameBean.panelAction(" + event + ")");
        this.userTaskManager.storeAllElements();
        String elementName = event.getElementName();
        if (elementName.endsWith("OKButton")) {
            if (this.isInputGood()) {
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add(this.m_sNameEdit);
                rowData.add(this.m_sAddressEdit);
                rowData.add(this.m_sNetworkMaskEdit);
                String accessButton = this.getAccessTypeSelection()[0];
                int i = 0;
                while (i < 2) {
                    if (accessButton.equals(this.accessButtons[i])) {
                        rowData.add(this.accessTypes[i]);
                    }
                    ++i;
                }
                PanelTaskletRequest request = new PanelTaskletRequest();
                request.setData("PANEL", "ComNamePanel");
                request.setData("EVENT", "OK");
                request.setData("DATA", rowData);
                this.postTaskletRequest(request);
            }
        } else if (elementName.endsWith("CancelButton")) {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("PANEL", "ComNamePanel");
            request.setData("EVENT", "CANCEL");
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- SnmpComNameBean.panelAction()");
    }

    private boolean isInputGood() {
        if (this.getNameEdit().length() <= 0) {
            this.showSnmpMessage(new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_NAME_MISSING_TEXT_KEY));
            return false;
        }
        if (this.getAddressEdit().length() > 0) {
            try {
                InetAddress.getByName(this.getAddressEdit());
            }
            catch (UnknownHostException exc) {
                this.showSnmpMessage(new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_ADDRESS_INVALID_TEXT_KEY));
                return false;
            }
        } else {
            this.showSnmpMessage(new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_ADDRESS_MISSING_TEXT_KEY));
            return false;
        }
        if (this.getNetworkMaskEdit().length() > 0) {
            try {
                InetAddress.getByName(this.getNetworkMaskEdit());
            }
            catch (UnknownHostException exc) {
                this.showSnmpMessage(new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_NETWORK_MASK_INVALID_TEXT_KEY));
                return false;
            }
        } else {
            this.showSnmpMessage(new LocalizableText(SNMP_MESSAGES_FILENAME, SNMP_MESSAGE_BOX_TITLE_KEY), new MessageText(SNMP_MESSAGES_FILENAME, SNMP_NETWORK_MASK_MISSING_TEXT_KEY));
            return false;
        }
        return true;
    }

    private void showSnmpMessage(LocalizableText title, MessageText message) {
        try {
            CommonMsgApp.showMessageBox(this.userTaskManager, title, message);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
    }
}

